/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.client.gui.util.ITopButtonListener;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleTransporter;
import noppes.npcs.util.Util;

public class GuiTransportSelection
extends GuiNPCInterface
implements ITopButtonListener,
IScrollData,
ICustomScrollListener {
    private boolean canTransport = true;
    protected int bxSize = 0;
    protected int bySize = 0;
    private final ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/smallbg.png");
    private GuiCustomScroll scroll;
    private final Map<String, Integer> data = new TreeMap<String, Integer>();
    private TransportLocation locSel;
    private Map<ItemStack, Boolean> barterItems;

    public GuiTransportSelection(EntityNPCInterface npc) {
        super(npc);
        this.xSize = 176;
        this.drawDefaultBackground = false;
        this.title = "";
        NoppesUtilPlayer.sendData(EnumPlayerPacket.TransportCategoriesGet, new Object[0]);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (button.getID() == 0 && this.locSel != null) {
            this.close();
            NoppesUtilPlayer.sendData(EnumPlayerPacket.Transport, this.locSel.id);
        }
    }

    @Override
    public void func_146276_q_() {
        super.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.resource);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 176, 222);
        this.barterItems = null;
        if (this.locSel == null) {
            return;
        }
        if (this.bxSize > 0) {
            int w = this.bxSize + 13;
            int h = this.bySize + 18;
            int x = this.guiLeft + 176;
            int y = this.guiTop + 14;
            this.field_146297_k.func_110434_K().func_110577_a(this.resource);
            this.func_73729_b(x, y, 176 - w, 0, w, h);
            this.func_73729_b(x, y + h, 176 - w, 218, w, 4);
            x += 5;
            y += 4;
            if (!this.locSel.inventory.func_191420_l()) {
                this.field_146289_q.func_175065_a(new TextComponentTranslation("market.barter", new Object[0]).func_150254_d(), (float)x, (float)y, CustomNpcs.LableColor.getRGB(), false);
            }
            if (this.locSel.money > 0L) {
                this.field_146289_q.func_175065_a(Util.instance.getTextReducedNumber(this.locSel.money, true, true, false) + " " + CustomNpcs.displayCurrencies, (float)x, (float)(y += 32), CustomNpcs.LableColor.getRGB(), false);
            }
        }
        this.bxSize = 0;
        this.bySize = 0;
        if (!this.locSel.inventory.func_191420_l()) {
            GlStateManager.func_179094_E();
            this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
            this.barterItems = Util.instance.getInventoryItemCount((EntityPlayer)this.player, this.locSel.inventory);
            int slot = 0;
            this.canTransport = true;
            for (ItemStack stack : this.barterItems.keySet()) {
                int u = this.guiLeft + this.xSize + 5 + slot % 3 * 18;
                int v = this.guiTop + 30 + slot / 3 * 18;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(u, v, 0, 0, 18, 18);
                if (this.canTransport) {
                    this.canTransport = this.barterItems.get(stack);
                }
                if (this.getButton(0) != null && this.getButton(0).isHovered()) {
                    Gui.func_73734_a((int)(u + 1), (int)(v + 1), (int)(u + 17), (int)(v + 17), (int)(this.barterItems.get(stack) != false ? -2147418368 : (this.player.field_71075_bZ.field_75098_d ? -2130743808 : -2130771968)));
                }
                ++slot;
            }
            float a = (float)slot / 3.0f;
            this.bxSize = (a >= 1.0f ? 3 : (a >= 0.6666667f ? 2 : 1)) * 18;
            this.bySize = (int)(Math.ceil(a) * 18.0);
            GlStateManager.func_179121_F();
        }
        if (this.locSel.money > 0L) {
            this.bySize += 14;
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        if (this.locSel != null && !this.locSel.inventory.func_191420_l()) {
            int slot = 0;
            for (ItemStack stack : this.barterItems.keySet()) {
                int u = this.guiLeft + this.xSize + 5 + slot % 3 * 18;
                int v = this.guiTop + 31 + slot / 3 * 18;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)u, (float)v, (float)50.0f);
                RenderHelper.func_74520_c();
                this.field_146297_k.func_175599_af().func_180450_b(stack, 0, 0);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
                this.func_73731_b(this.field_146297_k.field_71466_p, "" + stack.func_190916_E(), 13 - (stack.func_190916_E() > 9 ? 6 : 0), 9, -1);
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
                if (this.isMouseHover(mouseX, mouseY, u, v, 18, 18)) {
                    this.setHoverText(new ArrayList<String>(stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL))));
                }
                ++slot;
            }
        }
        if (this.getButton(0) != null) {
            IGuiNpcButton button = this.getButton(0);
            button.setEnabled(this.canTransport && this.locSel != null);
            if (!button.isEnabled() && button.isHovered()) {
                if (this.locSel == null) {
                    this.setHoverText(new TextComponentTranslation("transporter.hover.not.select", new Object[0]).func_150254_d(), new Object[0]);
                } else if (this.locSel.money > ClientProxy.playerData.game.getMoney()) {
                    this.setHoverText(new TextComponentTranslation("transporter.hover.not.money", new Object[0]).func_150254_d(), new Object[0]);
                } else {
                    this.setHoverText(new TextComponentTranslation("transporter.hover.not.item", new Object[0]).func_150254_d(), new Object[0]);
                }
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    public void func_73866_w_() {
        int id;
        TransportLocation loc;
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - 222) / 2;
        String title = "";
        TransportController tData = TransportController.getInstance();
        if (this.npc != null && this.npc.advanced.roleInterface instanceof RoleTransporter && (loc = tData.getTransport(id = ((RoleTransporter)this.npc.advanced.roleInterface).transportId)) != null) {
            title = new TextComponentTranslation(loc.category.title, new Object[0]).func_150254_d() + ": " + new TextComponentTranslation(loc.name, new Object[0]).func_150254_d();
        }
        this.addLabel(new GuiNpcLabel(0, title, this.guiLeft + (this.xSize - this.field_146289_q.func_78256_a(title)) / 2, this.guiTop + 10));
        this.addButton(new GuiNpcButton(0, this.guiLeft + 10, this.guiTop + 192, 156, 20, new TextComponentTranslation("transporter.travel", new Object[0]).func_150254_d()));
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
        }
        this.scroll.setSize(156, 165);
        this.scroll.guiLeft = this.guiLeft + 10;
        this.scroll.guiTop = this.guiTop + 20;
        this.addScroll(this.scroll);
        ArrayList<String> list = new ArrayList<String>(this.data.keySet());
        this.scroll.setList(list);
        if (!this.data.isEmpty()) {
            ArrayList<String> suffixes = new ArrayList<String>();
            ArrayList<Integer> colors = new ArrayList<Integer>();
            for (String name : list) {
                int color = new Color(-16711936).getRGB();
                int redC = new Color(-65536).getRGB();
                String sfx = "";
                TransportLocation loc2 = tData.getTransport(this.data.get(name));
                if (loc2 != null) {
                    if (!(loc2.money <= 0L && loc2.inventory.func_191420_l() || loc2.money <= 0L)) {
                        sfx = Util.instance.getTextReducedNumber(loc2.money, true, true, false) + " " + CustomNpcs.displayCurrencies;
                        if (loc2.money > 0L && loc2.money > ClientProxy.playerData.game.getMoney()) {
                            color = redC;
                        }
                    }
                    if (!loc2.inventory.func_191420_l() && color != redC) {
                        sfx = sfx + "\u00a77 [\u00a76I\u00a77]";
                        Map<ItemStack, Boolean> items = Util.instance.getInventoryItemCount((EntityPlayer)this.player, loc2.inventory);
                        for (ItemStack s : items.keySet()) {
                            if (items.get(s).booleanValue()) continue;
                            color = redC;
                            break;
                        }
                    }
                }
                suffixes.add(sfx);
                colors.add(color);
            }
            this.scroll.setColors(colors);
            this.scroll.setSuffixes(suffixes);
        }
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 || this.isInventoryKey(i)) {
            this.close();
        }
    }

    @Override
    public void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        this.scroll.func_73864_a(i, j, k);
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (this.data.containsKey(scroll.getSelected())) {
            this.locSel = TransportController.getInstance().getTransport(this.data.get(scroll.getSelected()));
            this.func_73866_w_();
        }
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
        if (this.locSel != null) {
            this.close();
            NoppesUtilPlayer.sendData(EnumPlayerPacket.Transport, this.locSel.id);
        }
    }

    @Override
    public void setData(Vector<String> list, HashMap<String, Integer> dataMap) {
        this.data.clear();
        for (String key : dataMap.keySet()) {
            String name = new TextComponentTranslation(key, new Object[0]).func_150254_d();
            this.data.put(name, dataMap.get(key));
        }
        this.func_73866_w_();
    }

    @Override
    public void setSelected(String selected) {
    }
}

